/*==============================================================================*/
/* Database name:  schuksoft                                                */
/* DBMS name:      MySQL 4.1.11                                               */
/*==============================================================================*/
/* Program :       Create_Tables.sql                                            */
/* Author  :       Markus Kaatze, RS an der Burg, markus@kaatze.de              */
/* Created on:     28.September 2004                                               */
/* Purpose :       Creates all schuksoft database tables                    */
/*==============================================================================*/


DROP TABLE IF EXISTS USER;
DROP TABLE IF EXISTS Artikel;
DROP TABLE IF EXISTS Artikelgruppe;
DROP TABLE IF EXISTS LIEFERANTEN;
DROP TABLE IF EXISTS UMSATZ;
DROP TABLE IF EXISTS Kasse;



/*==============================================================================*/
/* Table : USER                                                              */
/* STATUS: Schler=1, admin=2, Lehrer=3                                                        */
/*==============================================================================*/

create table USER (
   USER_ID              INTEGER            not null         primary key        auto_increment,
   NAME                 VARCHAR(30)        not null,
   VORNAME              VARCHAR(20),
   USER_NAME            VARCHAR(20)        not null,
   USER_PASSWORT        VARCHAR(10)        not null,
   STATUS               TINYINT            not null,
   kasse_id             integer,
   SESSION_ID           VARCHAR(50)        unique);

/*==============================================================================*/
/* Table : lieferanten                                                                 */
/*==============================================================================*/

create table LIEFERANTEN (
   lieferant_ID         varchar(4)            not null         primary key,
   Name                 VARCHAR(255),
   Strasse              VARCHAR(255),
   Ort                  VARCHAR(255),
   PLZ                  VARCHAR(5),
   tel                  VARCHAR(13),
   mail                 VARCHAR(255),
   url                  VARCHAR(255));

/*==============================================================================*/
/* Table : artikelgruppe                                                                 */
/*==============================================================================*/

CREATE TABLE artikelgruppe (
   ArtGrNr              varchar(2)         NOT NULL         primary key,
   ArtGruppe            varchar(255));

/*==============================================================================*/
/* Table : artikel     mwst 1=7%, 2=16%                                         */
/*==============================================================================*/

create table artikel (
   ArtNr                VARCHAR(6)         not null         primary key,
   Name                 VARCHAR(12),
   artikel              varchar(255),
   lieferant_ID         varchar(4),
   V_Preis              decimal(8,2)         DEFAULT '0.00',
   E_Preis              decimal(8,2)         DEFAULT '0.00',
   Bestand_soll         INTEGER,
   Bestand_ist          Integer,
   mwst                 INTEGER              DEFAULT '0',
   Bild                 varchar(255),
   ArtGrNr              varchar(2)         NOT NULL,
   taste                VARCHAR(1));

/*==============================================================================*/
/* Table : umsatz                                                                 */
/*==============================================================================*/

CREATE TABLE umsatz (
   umsatz_id                   integer            not null         primary key        auto_increment,
   datum                       DATETIME,
   ArtNr                       Varchar(6),
   anz                         integer,
   akt_preis                   decimal(8,2),
   kasse_id                    integer);

/*==============================================================================*/
/* Table : kasse                                                                 */
/*==============================================================================*/

CREATE TABLE kasse (
   Kasse_id                    integer            not null         primary key        auto_increment,
   Datum                       DATE,
   Kasse                       integer,
   User_id                     integer,
   Umsatz_mwst_1               decimal(8,2),
   Umsatz_mwst_2               decimal(8,2),
   Kasse_Bestand_Eingang       decimal(8,2),
   Kasse_Entname               decimal(8,2),
   Kasse_Bestand_Abschluss     decimal(8,2));

/*==============================================================================*/
/* Default-Werte eingeben                                                       */
/*==============================================================================*/

Insert into user values (null,'Administrator','','admin','admin',3,null,null);
Insert into user values (null,'gast','','gast','gast',1,null,null);
Insert into lieferanten values ('plus','Plus','','','','','','');
Insert into lieferanten values ('stap','Stapeles','','','','','','');
Insert into lieferanten values ('kelo','Kellocks','','','','','','');
Insert into lieferanten values ('rati','Ratio','','','','','','');
Insert into lieferanten values ('sons','Sonstige','','','','','','');
INSERT INTO artikelgruppe VALUES ("BW","Backwaren");
INSERT INTO artikelgruppe VALUES ("FW","Frischwaren");
INSERT INTO artikelgruppe VALUES ("OB","Obst");
INSERT INTO artikelgruppe VALUES ("GE","Getraenke");
INSERT INTO artikelgruppe VALUES ("RI","Riegel");
INSERT INTO artikelgruppe VALUES ("CE","Cerealien");
INSERT INTO artikelgruppe VALUES ("NF","Non Food");
INSERT INTO artikelgruppe VALUES ("SW","Schreibwaren");
INSERT INTO artikelgruppe VALUES ("NA","Nicht aktuell");
INSERT INTO artikel VALUES ('Storno', 'Storno', NULL , NULL , '0.00', '0.00', NULL , NULL , '0', NULL , '', NULL);